local MakePlayerCharacter = require "prefabs/player_common"

--Assets basically animate your player
local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
		Asset( "ANIM", "anim/player_mime.zip"), 
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		Asset( "ANIM", "anim/dib.zip" ),
		Asset( "ANIM", "anim/ghost_dib_build.zip" ),

}

local prefabs =
{
}

local start_inv = 
{
}

local function common_postinit(inst)

inst.avatar_tex   = "avatar_dib.tex"
inst.avatar_atlas = "images/avatars/avatar_dib.xml"
inst.avatar_ghost_tex   = "avatar_ghost_dib.tex"
inst.avatar_ghost_atlas = "images/avatars/avatar_ghost_dib.xml"


	STRINGS.CHARACTERS.dib = require "speech_dib"
end

local function ondudewakeup()
    TheCamera:SetDefault()
    --SaveGameIndex:SaveCurrent(function() end)            
end

local function onresurrect(inst, dude)
    dude:Show()

    if dude and dude.components.burnable then
    	dude.components.burnable.burning = true
    end

    if dude and dude.components.burnable then 
    	dude.components.burnable.burning = false
    end

    --inst.SoundEmitter:PlaySound("dontstarve/common/resurrectionstone_break")
    --inst.components.lootdropper:DropLoot()
    --inst:Remove()

    if dude.components.hunger then
        dude.components.hunger:SetPercent(2 / 3)
    end

    if dude.components.health then
        dude.components.health:Respawn(TUNING.RESURRECT_HEALTH)
    end

    if dude.components.sanity then
        dude.components.sanity:SetPercent(.5)
    end
	
    dude.components.hunger:Resume()

    dude.sg:GoToState("wakeup")

    dude:DoTaskInTime(3, ondudewakeup)
end

local function OnHaunt(inst)

    --haunter:Hide()
    --TheCamera:SetDistance(12)
	--haunter.components.hunger:Pause()
	
    --scheduler:ExecuteInTime(3, onresurrect, nil, inst, haunter)
	
	if inst.components.hunger then
        inst.components.hunger:DoDelta( -40 )
    end

    if inst.components.health then
        inst.components.combat:GetAttacked(inst, (TUNING.REVIVER_CRAFT_HEALTH_PENALTY/2))
    end

    if inst.components.sanity then
        inst.components.sanity:DoDelta( -(TUNING.REVIVER_CRAFT_SANITY_PENALTY/2))
    end
	
end

local function doresurrect(inst, dude)
	inst.isresurrecting = true
    --HACK: see explosive component
    TheWorld:PushEvent("ms_nextcycle")
    --dude.Transform:SetPosition(inst.Transform:GetWorldPosition())
    dude:Hide()
    dude:ClearBufferedAction()

    if dude.HUD then
        dude.HUD:Hide()
    end
    if dude.components.playercontroller then
        dude.components.playercontroller:Enable(false)
    end

    TheCamera:SetDistance(12)
	dude.components.hunger:Pause()

    scheduler:ExecuteInTime(3, onresurrect, nil, inst, dude)
	
end

local function onbecamerobot(inst)
	inst:AddTag("resurrector")
	inst:AddComponent("resurrector")
	inst.components.resurrector.doresurrect = doresurrect
	inst.components.resurrector.penalty = 1
	inst:AddComponent("hauntable")
	inst.components.hauntable:SetOnUnHauntFn(OnHaunt)
	inst.components.hauntable:SetHauntValue(TUNING.HAUNT_INSTANT_REZ)
end

local function master_postinit(inst)
STRINGS.CHARACTERS.dib = require "speech_dib"
	--inst:AddComponent("inspectable")
	
	--This is how you choose a sound.
	inst.soundsname = "dib"
	inst.spark_time = 3
	--Adding a Minimap Icon for zim
	inst.MiniMapEntity:SetIcon("dib.tex")
	local WalkSpeed = (TUNING.WILSON_WALK_SPEED * 1)
	local RunSpeed = (TUNING.WILSON_RUN_SPEED * 1)
	inst.components.hunger:SetMax(200)
	inst.components.health.maxhealth = 150
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1)
	inst.components.sanity:SetMax(TUNING.WILSON_SANITY * 0.5)
	inst.components.combat.damagemultiplier = 0.8		
	inst.components.sanity.dapperness = (TUNING.DAPPERNESS_SMALL*0.5)
	inst:AddComponent("reader")
	--inst:AddTag("noauradamage")
	STRINGS.NAMES.dib = "Dib"
	inst:AddComponent("hauntable")
	inst.components.hauntable:SetOnUnHauntFn(OnHaunt)
	inst.components.hauntable:SetHauntValue(TUNING.HAUNT_INSTANT_REZ)
	inst:AddTag("resurrector")
	inst:AddComponent("resurrector")
	inst.components.resurrector.doresurrect = doresurrect
	inst.components.resurrector.penalty = 1
	inst:ListenForEvent("ms_respawnedfromghost", onbecamerobot)
end
	
return MakePlayerCharacter("dib", prefabs, assets, common_postinit, master_postinit, start_inv)

	
	
	
	